import geopandas as gpd
import os
import sys
import urllib.request
from zipfile import ZipFile
import winreg
import ssl

ssl._create_default_https_context = ssl._create_stdlib_context

dmr = sys.argv[1]
# dmr = '5'

script_path = os.path.dirname(os.path.realpath(__file__))

if dmr == "SHP":
    typ = "ZABAGED-vyskopis"
if dmr == "1":
    typ = "DMP1G"
if dmr == "4":
    typ = "DMR4G"
if dmr == "5":
    typ = "DMR5G"

if not os.path.exists(script_path+'\\'+dmr):
    os.makedirs(script_path+'\\'+dmr)

try:
     files = os.listdir(script_path+'\\'+dmr)
     for file in files:
       file_path = os.path.join(script_path+'\\'+dmr, file)
       if os.path.isfile(file_path):
         os.remove(file_path)
except Exception as e:
    print(e)


url_path = f'https://openzu.cuzk.cz/opendata/{typ}/epsg-5514/'


def set_registry_value(key_path, value_name, value_data):
    try:
        # Otevření klíče v registru (zde je uveden příklad klíče pro CurrentUser)
        key = winreg.HKEY_CURRENT_USER

        # Získání handleru pro klíč
        key_handle = winreg.OpenKey(key, key_path, 0, winreg.KEY_SET_VALUE)

        # Zápis hodnoty do registru
        winreg.SetValueEx(key_handle, value_name, 0, winreg.REG_SZ, value_data)

        # Uzavření handleru klíče
        winreg.CloseKey(key_handle)

    except Exception as e:
        pass


def create_registry_key(key_path):
    try:
        # Otevření nadřazeného klíče v registru (zde je uveden příklad klíče pro CurrentUser)
        key = winreg.HKEY_CURRENT_USER

        # Vytvoření nového klíče v registru
        key_handle = winreg.CreateKey(key, key_path)

        winreg.CloseKey(key_handle)

    except Exception as e:
        pass


def mapListSm05():

    # Načtěte data z CSV souboru
    # input()

    try:
        # data = gpd.read_file(os.path.join(script_path, 'body.csv'))
        data = gpd.read_file(script_path+'/body.shp')
        # data = gpd.read_file(r'c:\ProgramData\AtlasLtd\AtlasDMT\DMRCuzk\body.shp')
    except Exception as e:
        # print(e)
        # print(script_path+r'\body.csv')
        # input()

        f = open(script_path + '/utferror', 'w')
        f.write(str(e))
        f.close()
        exit()

    data.crs = 5514

    data_polygon = gpd.read_file(script_path+'/mapovelisty.gpkg',
                                 # layer='ztm5_edice_p_celacr')
                                 layer='maplist')  # Předpokládáme formát GeoJSON

    # Proveďte prostorové spojení bodů s polygony
    spatial_join = gpd.sjoin(data, data_polygon, predicate='within')

    # Tento výsledek bude obsahovat polygonovou vrstvu s přidanými atributy z vrstvy bodů, které do polygonů spadají
    # print(data_polygon.iloc[0])
    jedinecne = []

    for pol in spatial_join.iloc:
        if pol['SM5_KOD'] not in jedinecne:
            jedinecne.append(pol['SM5_KOD'])

    create_registry_key(r"Software\Atlas DMT\dmr_progress")
    set_registry_value(r"Software\Atlas DMT\dmr_progress", 'num', str(len(jedinecne)))


    listy = open(script_path+'/listy.txt', 'w', encoding='utf-8')
    s = len(jedinecne)
    for i, pol in enumerate(jedinecne):

        if os.path.isfile(script_path+'/prerus'):
            exit()

        output_path = os.path.join(script_path, f'{dmr}/download.zip')

        # if not os.path.isfile(script_path+f'/{dmr}/'+pol+'.laz'):
        try:
            endpointurl = url_path+pol+'.zip'
            urllib.request.urlretrieve(endpointurl, output_path)
        except urllib.error.URLError:
            interfail = open(script_path+'/connectionfail', 'w')
            interfail.close()
            exit()

        if dmr == 'SHP':
            zip = ZipFile(output_path, 'r')
            for shp in zip.namelist():
                if 'shp' in shp and 'Popis' not in shp and 'Maska' not in shp and 'Spado' not in shp:
                    listy.write(pol + shp.split('_')[1]+'\n')
            zip.close()

        ZipFile(output_path).extractall(path=os.path.dirname(output_path))

        if dmr == 'SHP':
            zip = ZipFile(output_path)
            for ex in zip.namelist():
                dstpath = script_path+f'/{dmr}/'+pol + ex.split('_')[1]
                srcpath = script_path+f'/{dmr}/'+ex
                os.rename(srcpath, dstpath)
            zip.close()

        os.remove(output_path)

        if dmr != 'SHP':
            listy.write(pol+'\n')

        set_registry_value(r"Software\Atlas DMT\dmr_progress", 'progress', str(i+1))

        # input()
        # print(f'{i};{s}')
        # progress_var.set(i*100/s)

        # jedinecne.append(pol['SM5_KOD'])

    listy.close()

    f = open(script_path+'/hotovo', 'w')
    f.close()


# mapListSm05()

if __name__ == "__main__":


    # mapListSm05()
    try:
        mapListSm05()
        #
    except Exception as e:
        ef = open(script_path+'/except', 'w')
        ef.write(str(e))
        ef.close()

